import pandas as pd  
import numpy as np  
from sklearn.preprocessing import StandardScaler, LabelEncoder  
from sklearn.cluster import KMeans  
import pickle  
from decision_company import read_csv_file, col_copy, create_standard_scaler, fit_transform_standard_scaler, create_label_encoder, fit_transform_label_encoder, get_dummies, create_kmeans, fit_predict_kmeans, fetch_column, check_elements_in_list, extract_unique_values, convert_np_to_list, col_assign_val
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Extract the important columns  
important_columns = ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status']  
data_for_clustering = col_copy(credit_customers, important_columns)  
  
# Preprocess the data  
le_savings_status = create_label_encoder()  
le_employment = create_label_encoder()  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(le_savings_status, data_for_clustering['savings_status']))
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(le_employment, data_for_clustering['employment']))
data_for_clustering = get_dummies(data_for_clustering, columns=['credit_history'], drop_first=True)  
  
# Normalize the data  
scaler = create_standard_scaler()  
data_for_clustering_scaled = fit_transform_standard_scaler(scaler, data_for_clustering)  
  
# Perform K-means clustering  
kmeans = create_kmeans(n_clusters=4, random_state=42)  
cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  
  
# Add the cluster labels to the original dataset  
col_assign_val(credit_customers, 'cluster', cluster_labels)  
  
# Filter the dataset based on the specified criteria  
good_credit_history = check_elements_in_list(fetch_column(credit_customers, 'credit_history'), ['existing paid', 'all paid'])  
age_group = (fetch_column(credit_customers, 'age') >= 25) & (fetch_column(credit_customers, 'age') <= 45)  
stable_employment = check_elements_in_list(fetch_column(credit_customers, 'employment'), ['>=7', '4<=X<7'])  
  
# Combine the filters and apply them to the dataset  
target_customers = credit_customers[good_credit_history & age_group & stable_employment] 
  
# Extract the target customer segments  
target_customer_segments = convert_np_to_list(extract_unique_values(fetch_column(target_customers, 'cluster')))  
  
# Return the list of target customer segments  
print("target_customer_segments:\n", target_customer_segments)  
pickle.dump(target_customer_segments, open("./ref_result/target_customer_segments.pkl", "wb"))  
